/*********************************************************************/
//Development Board : 
//Target			: STC12C5A60S2
//Clock Frequency	: 11.0592MHz
//Designer			: gie.com.my
//Project Name		: LED.uvproj
//Code Name			: delay.c
/*********************************************************************/

/*
 Microcontrollers (and many other electrical systems) use crystals to syncrhronize operations. 
 The 8051 uses the crystal for precisely that: to synchronize its operation. Effectively, 
 the 8051 operates using what are called "machine cycles." A single machine cycle is the 
 minimum amount of time in which a single 8051 instruction can be executed. 
 although many instructions take multiple cycles.

 A cycle is, in reality, 12 pulses of the crystal. That is to say, if an instruction takes 
 one machine cycle to execute, it will take 12 pulses of the crystal to execute. Since we know 
 the crystal is pulsing 11,059,000 times per second and that one machine cycle is 12 pulses, 
 we can calculate how many instruction cycles the 8051 can execute per second:

    11,059,000 / 12 = 921,583 ==> T = 1.085us (per cycle) 

 This means that the 8051 can execute 921,583 single-cycle instructions per second. Since a large 
 number of 8051 instructions are single-cycle instructions it is often considered that the 8051 
 can execute roughly 1 million instructions per second, although in reality it is less--and, 
 depending on the instructions being used, an estimate of about 600,000 instructions per second 
 is more realistic.

 For example, if you are using exclusively 2-cycle instructions you would find that the 8051 
 would execute 460,791 instructions per second. The 8051 also has two really slow instructions 
 that require a full 4 cycles to execute--if you were to execute nothing but those instructions 
 youd find performance to be about 230,395 instructions per second.

*/


#include "delay.h"


//delay x milliseconds
void delayXms(Word x)
{
	Byte i;
	while(x--)
	{
		for(i = 0;i < 70;i ++); //about 13 machine cycle => 13 * 1.085us * 70 = 987us = about 1ms
	}
}

//delay x microseconds
void delayXus(Word x)
{
	while(x--)		
		_nop_();	//1 machine cycle => 1 * 1.085us = 1.085us 
}
